#target illustrator

function main() {
    if (app.documents.length === 0) {
        alert("Ouvre un document Illustrator.");
        return;
    }

    var doc = app.activeDocument;

    if (doc.selection.length !== 2) {
        alert("Sélectionne deux groupes : d'abord l’insigne, puis le logotype.");
        return;
    }

    var insigne = doc.selection[0];
    var logotype = doc.selection[1];

    var bLogotype = logotype.geometricBounds;
    var logotypeWidth = bLogotype[2] - bLogotype[0];
    var logotypeHeight = bLogotype[1] - bLogotype[3];
    var logotypeTop = bLogotype[1];
    var logotypeBottom = bLogotype[3];
    var logotypeLeft = bLogotype[0]; // ajout pour position horizontale
    var logotypeRight = bLogotype[2];

    var bInsigne = insigne.geometricBounds;
    var insigneHeight = bInsigne[1] - bInsigne[3];

    var third = logotypeHeight / 3;

    // Nouvelle hauteur cible : logotype + 2/3 (1/3 au-dessus + 1/3 en dessous)
    var targetHeight = logotypeHeight + 2 * third;
    var scale = (targetHeight / insigneHeight) * 100;
    insigne.resize(scale, scale);

    // Recalculer les bounds après redimensionnement
    var bInsigneNew = insigne.geometricBounds;
    var insigneWidth = bInsigneNew[2] - bInsigneNew[0];
    var insigneHeightNew = bInsigneNew[1] - bInsigneNew[3];

    // Positionner le haut de l’insigne à la ligne "haut du logotype + 1/3"
    var topLineAbove = logotypeTop + third;
    var newInsigneY = topLineAbove;

    // Position horizontale : à gauche du logotype
    var insigneX = logotypeLeft - insigneWidth - third; // insigne à gauche
    insigne.position = [insigneX, newInsigneY];

    // === REPÈRES VISUELS ===
    var guideColor = new RGBColor();
    guideColor.red = 180;
    guideColor.green = 180;
    guideColor.blue = 180;

    var margin = 40;
    var fullWidth = logotypeRight + margin;

    function drawLine(y) {
        var line = doc.pathItems.add();
        line.setEntirePath([
            [insigneX - margin, y],
            [fullWidth, y]
        ]);
        line.stroked = true;
        line.strokeWidth = 1;
        line.strokeColor = guideColor;
        line.filled = false;
    }

    function drawVerticalLine(x, top, bottom) {
        var line = doc.pathItems.add();
        line.setEntirePath([
            [x, top],
            [x, bottom]
        ]);
        line.stroked = true;
        line.strokeWidth = 1;
        line.strokeColor = guideColor;
        line.filled = false;
    }

    var topAbove = logotypeTop + third;
    var bottomBelow = logotypeBottom - third;

    // Lignes horizontales principales
    drawLine(logotypeTop);              // haut logotype
    drawLine(logotypeTop - third);      // 1/3
    drawLine(logotypeTop - 2 * third);  // 2/3
    drawLine(logotypeBottom);           // bas logotype

    // Lignes au-dessus
    drawLine(topAbove);
    drawLine(topAbove - third / 3);
    drawLine(topAbove - 2 * (third / 3));

    // Lignes en-dessous
    drawLine(bottomBelow);
    drawLine(bottomBelow + third / 3);
    drawLine(bottomBelow + 2 * (third / 3));

    // Lignes verticales entre insigne et logotype
    var rightInsigneX = insigneX + insigneWidth;
    var leftLogotypeX = logotypeLeft; // ne pas déplacer logotype
    drawVerticalLine(rightInsigneX, topAbove, bottomBelow);
    drawVerticalLine(leftLogotypeX, topAbove, bottomBelow);

    alert("Insigne parfaitement ajustée autour du logotype (logotype non déplacé) !");
}

main();
